/*
 * CCSI_Socket.c
 *
 *  Created on: Jul 12, 2020
 *      Author: a0489203
 */

#include "TLC6983DMA.h"
#include "CCSI_Socket.h"




/* Function Name: CCSI_write
 *
 * Purpose: Write data bytes
 *
 * Parameters:
 * headBytes -> Head bytes of the command.
 * dataBytes -> Data bytes, MSB first.
 * length -> Length of data bytes.
 *
 */
void CCSI_write(uint16_t headBytes, uint16_t *dataBytes, uint8_t length){
    //__disable_interrupt();
    uint8_t i = 0;
    for (i = 0; i < 18; ++i) {
        dmaTxData[i] = 0x00;//clear all bits and set start bit.
    }
    //Head bytes
    dmaTxData[0] |= (headBytes >> 9) & 0x007F;//7 bits
    dmaTxData[1] |= (headBytes >> 1) & 0x00FF;//8 bits
    dmaTxData[2] |= (headBytes << 7) & 0x0080;//1 bit
    if ((dmaTxData[2] & 0x0080) == 0) {
        dmaTxData[2] |= 0x0040;
    }
    else {
        dmaTxData[2] &= ~(0x0040);
    }//Check bit


    //Data bytes
    //If length of data bytes is 3
    if(length == 3){
        //data bytes
        //dataBytes[0]
        dmaTxData[2] |= (dataBytes[0] >> 10) & 0x003F;//6 bits
        dmaTxData[3] |= (dataBytes[0] >> 2) & 0x00FF;//8 bits
        dmaTxData[4] |= (dataBytes[0] << 6) & 0x00C0;//2 bits
        if ((dmaTxData[4] & 0x0040) == 0) {
            dmaTxData[4] |= 0x0020;
        }
        else {
            dmaTxData[4] &= ~(0x0020);
        }//Check bit
        //dataBytes[1]
        dmaTxData[4] |= (dataBytes[1] >> 11) & 0x001F;//5 bits
        dmaTxData[5] |= (dataBytes[1] >> 3) & 0x00FF;//8 bits
        dmaTxData[6] |= (dataBytes[1] << 5) & 0x00E0;//3 bits
        if ((dmaTxData[6] & 0x0020) == 0) {
            dmaTxData[6] |= 0x0010;
        }
        else {
            dmaTxData[6] &= ~(0x0010);
        }//Check bit
        //dataBytes[2]
        dmaTxData[6] |= (dataBytes[2] >> 12) & 0x000F;//4 bits//0x001F
        dmaTxData[7] |= (dataBytes[2] >> 4) & 0x00FF;//8 bits
        dmaTxData[8] |= (dataBytes[2] << 4) & 0x00F0;//4 bits
        if ((dmaTxData[8] & 0x0010) == 0) {
            dmaTxData[8] |= 0x0008;
        }
        else {
            dmaTxData[8] &= ~(0x0008);
        }//Check bit
        //End bytes
        dmaTxData[8] |= 0x0007;
        dmaTxData[9] |= 0xFF;
        dmaTxData[10] |= 0xFF;
    }


    //If length of data bytes is 6
    else if(length == 6){
        //data bytes
        //dataBytes[0]
        dmaTxData[2] |= (dataBytes[0] >> 10) & 0x003F;//6 bits
        dmaTxData[3] |= (dataBytes[0] >> 2) & 0x00FF;//8 bits
        dmaTxData[4] |= (dataBytes[0] << 6) & 0x00C0;//2 bits
        if ((dmaTxData[4] & 0x0040) == 0) {
            dmaTxData[4] |= 0x0020;
        }
        else {
            dmaTxData[4] &= ~(0x0020);
        }//Check bit
        //dataBytes[1]
        dmaTxData[4] |= (dataBytes[1] >> 11) & 0x001F;//5 bits
        dmaTxData[5] |= (dataBytes[1] >> 3) & 0x00FF;//8 bits
        dmaTxData[6] |= (dataBytes[1] << 5) & 0x00E0;//3 bits
        if ((dmaTxData[6] & 0x0020) == 0) {
            dmaTxData[6] |= 0x0010;
        }
        else {
            dmaTxData[6] &= ~(0x0010);
        }//Check bit
        //dataBytes[2]
        dmaTxData[6] |= (dataBytes[2] >> 12) & 0x000F;//4 bits
        dmaTxData[7] |= (dataBytes[2] >> 4) & 0x00FF;//8 bits
        dmaTxData[8] |= (dataBytes[2] << 4) & 0x00F0;//4 bits
        if ((dmaTxData[8] & 0x0010) == 0) {
            dmaTxData[8] |= 0x0008;
        }
        else {
            dmaTxData[8] &= ~(0x0008);
        }//Check bit



        //dataBytes[3]
        dmaTxData[8] |= (dataBytes[3] >> 13) & 0x0007;//3 bits
        dmaTxData[9] |= (dataBytes[3] >> 5) & 0x00FF;//8 bits
        dmaTxData[10] |= (dataBytes[3] << 3) & 0x00F8;//5 bits
        if ((dmaTxData[10] & 0x0008) == 0) {
            dmaTxData[10] |= 0x0004;
        }
        else {
            dmaTxData[10] &= ~(0x0004);
        }//Check bit

        //dataBytes[4]
        dmaTxData[10] |= (dataBytes[4] >> 14) & 0x0003;//2 bits
        dmaTxData[11] |= (dataBytes[4] >> 6) & 0x00FF;//8 bits
        dmaTxData[12] |= (dataBytes[4] << 2) & 0x00FC;//6 bits
        if ((dmaTxData[12] & 0x0004) == 0) {
            dmaTxData[12] |= 0x0002;
        }
        else {
            dmaTxData[12] &= ~(0x0002);
        }//Check bit

        //dataBytes[5]
        dmaTxData[12] |= (dataBytes[5] >> 15) & 0x0001;//1 bits
        dmaTxData[13] |= (dataBytes[5] >> 7) & 0x00FF;//8 bits
        dmaTxData[14] |= (dataBytes[5] << 1) & 0x00FE;//7 bits
        if ((dmaTxData[14] & 0x0002) == 0) {
            dmaTxData[14] |= 0x0001;
        }
        else {
            dmaTxData[14] &= ~(0x0001);
        }//Check bit
        //End bytes
        dmaTxData[15] |= 0xFF;
        dmaTxData[16] |= 0xFF;
        dmaTxData[17] |= 0xFF;
    }

    //If length of data bytes is 0
    else if(length == 0){
        dmaTxData[2] |= 0x003F;
        dmaTxData[3] |= 0xFF;
        dmaTxData[4] |= 0xFF;//End bit
    }


    //Send the command
    if(length == 3){
        dmaTransfer(11, 0, FALSE);
    }

    else if(length == 6){
        dmaTransfer(18, 0, FALSE);
    }

    else{
        dmaTransfer(5, 0 , FALSE);
    }
    //__enable_interrupt();
}

//write SRAM data for 5 device
void CCSI_write_sram(){

 /*   uint8_t i = 0;
    for (i = 0; i < 30; ++i) {
        dmaTxData[i] = 0x00;//clear all bits and set start bit.
    }*/
    //Head bytes
    dmaTxData[0] = 0x55;//7 bits
    dmaTxData[1] = 0x18;//8 bits
    dmaTxData[2] = 0x7f;//1 bit
    dmaTxData[3] = 0xff;
    dmaTxData[4] = 0xdf;
    dmaTxData[5] = 0xff;
    dmaTxData[6] = 0xef;
    dmaTxData[7] = 0xff;
    dmaTxData[8] = 0xf7;
    dmaTxData[9] = 0xff;
    dmaTxData[10] = 0xfb;
    dmaTxData[11] = 0xff;
    dmaTxData[12] = 0xfd;
    dmaTxData[13] = 0xff;
    dmaTxData[14] = 0xfe;
    dmaTxData[15] = 0xff;
    dmaTxData[16] = 0xff;
    dmaTxData[17] = 0x7f;
    dmaTxData[18] = 0xff;
    dmaTxData[19] = 0xBF;
    dmaTxData[20] = 0xff;
    dmaTxData[21] = 0xdf;
    dmaTxData[22] = 0xff;
    dmaTxData[23] = 0xef;
    dmaTxData[24] = 0xff;
    dmaTxData[25] = 0xf7;
    dmaTxData[26] = 0xff;
    dmaTxData[27] = 0xfb;
    //dmaTxData[28] = 0xff;//4 device end
    //dmaTxData[29] = 0xff;//4 device end
    dmaTxData[28] = 0xff;
    dmaTxData[29] = 0xfd;
    dmaTxData[30] = 0xff;
    dmaTxData[31] = 0xfe;
    dmaTxData[32] = 0xff;
    dmaTxData[33] = 0xff;
    dmaTxData[34] = 0x7f;
    //dmaTxData[35] = 0xff;//5 device end
    //dmaTxData[36] = 0xff;//5 device end
    dmaTxData[35] = 0xff;
    dmaTxData[36] = 0xBF;
    dmaTxData[37] = 0xff;
    dmaTxData[38] = 0xdf;
    dmaTxData[39] = 0xff;
    dmaTxData[40] = 0xef;
    //dmaTxData[41] = 0xff;//6 device end
    //dmaTxData[42] = 0xff;//6 device end
    dmaTxData[41] = 0xff;
    dmaTxData[42] = 0xf7;
    dmaTxData[43] = 0xff;
    dmaTxData[44] = 0xfb;
    dmaTxData[45] = 0xff;
    dmaTxData[46] = 0xfd;
    dmaTxData[47] = 0xff;
    dmaTxData[48] = 0xfe;
    dmaTxData[49] = 0xff;
    dmaTxData[50] = 0xff;
    dmaTxData[51] = 0x7f;
    dmaTxData[52] = 0xfF;
    dmaTxData[53] = 0xbf;
    //dmaTxData[54] = 0xff;//8 device end
    //dmaTxData[55] = 0xff;//8 device end
    dmaTxData[54] = 0xff;
    dmaTxData[55] = 0xdf;
    dmaTxData[56] = 0xff;
    dmaTxData[57] = 0xef;
    dmaTxData[58] = 0xff;
    dmaTxData[59] = 0xf7;
    dmaTxData[60] = 0xff;
    dmaTxData[61] = 0xfb;
    dmaTxData[62] = 0xff;
    dmaTxData[63] = 0xfd;
    dmaTxData[64] = 0xff;
    dmaTxData[65] = 0xfe;
    dmaTxData[66] = 0xff;
    dmaTxData[67] = 0xff;

    //Send the command
        dmaTransfer(68, 0, FALSE);
    //__enable_interrupt();
}


/* Function Name: CCSI_read
 *
 * Purpose: Read data bytes
 *
 * Parameters:
 * headBytes -> Head bytes of the command.
 *
 */
void CCSI_read(uint16_t headBytes){
    //__disable_interrupt();
    uint8_t i = 0;
    for (i = 0; i < 11; ++i) {
        dmaTxData[i] = 0x00;//clear all bits and set start bit.
    }
    dmaTxData[0] |= (headBytes >> 9) & 0x007F;//7 bits
    dmaTxData[1] |= (headBytes >> 1) & 0x00FF;//8 bits
    dmaTxData[2] |= (headBytes << 7) & 0x0080;//1 bit
    if ((dmaTxData[2] & 0x0080) == 0) {
        dmaTxData[2] |= 0x0040;
    }
    else {
        dmaTxData[2] &= ~(0x0040);
    }//Check bit
    dmaTxData[2] |= 0x003F;
    dmaTxData[3] |= 0xFF;
    dmaTxData[4] |= 0xFF;//End bit
    for(i = 4 ; i < 11 ; ++i){
        dmaTxData[i] |= 0xFF;
    }
    dmaTransfer(11, 11, TRUE);
    //Check the readBuffer then.
    //__enable_interrupt();
}
